//ROI manager is open with selected ROIs
//output results of 3 channels in one spreadsheet
//show the composite data incoporating R, G and B
//data format is area_R, mean_R, Xm_R, Ym_R, area_G, mean_G, Xm_G, Ym_G, area_B, mean_B, Xm_B, Ym_G

macro "output 3 channels"
{

roiManager("deselect");

//red channel

run("Clear Results");

Stack.setChannel(1);

run("Set Measurements...", "area mean center redirect=None decimal=5");

roiManager("Measure");

Num_ROIs=roiManager("count");

area_R=newArray(Num_ROIs);

mean_R=newArray(Num_ROIs);

Xm_R=newArray(Num_ROIs);

Ym_R=newArray(Num_ROIs);

for (i=0; i<Num_ROIs; i++)
{

area_R[i]=getResult("Area", i);

mean_R[i]=getResult("Mean", i);

Xm_R[i]=getResult("XM", i);

Ym_R[i]=getResult("YM", i);

}

//green channel

run("Clear Results");

Stack.setChannel(2);

run("Set Measurements...", "area mean center redirect=None decimal=5");

roiManager("Measure");

Num_ROIs=roiManager("count");

area_G=newArray(Num_ROIs);

mean_G=newArray(Num_ROIs);

Xm_G=newArray(Num_ROIs);

Ym_G=newArray(Num_ROIs);

for (i=0; i<Num_ROIs; i++)
{

area_G[i]=getResult("Area", i);

mean_G[i]=getResult("Mean", i);

Xm_G[i]=getResult("XM", i);

Ym_G[i]=getResult("YM", i);

}

//blue channel

run("Clear Results");

Stack.setChannel(3);

run("Set Measurements...", "area mean center redirect=None decimal=5");

roiManager("Measure");

Num_ROIs=roiManager("count");

area_B=newArray(Num_ROIs);

mean_B=newArray(Num_ROIs);

Xm_B=newArray(Num_ROIs);

Ym_B=newArray(Num_ROIs);

for (i=0; i<Num_ROIs; i++)
{

area_B[i]=getResult("Area", i);

mean_B[i]=getResult("Mean", i);

Xm_B[i]=getResult("XM", i);

Ym_B[i]=getResult("YM", i);

}

//show the composite data incoporating R, G and B


run("Clear Results");

for (i=0; i<Num_ROIs; i++)
{

setResult("area_R", i, area_R[i]);

setResult("mean_R", i, mean_R[i]);

setResult("Xm_R", i, Xm_R[i]);

setResult("Ym_R", i, Ym_R[i]);

setResult("area_G", i, area_G[i]);

setResult("mean_G", i, mean_G[i]);

setResult("Xm_G", i, Xm_G[i]);

setResult("Ym_G", i, Ym_G[i]);

setResult("area_B", i, area_B[i]);

setResult("mean_B", i, mean_B[i]);

setResult("Xm_B", i, Xm_B[i]);

setResult("Ym_B", i, Ym_B[i]);

}



}








